<?php

if ( ! defined( 'ABSPATH' ) ) {
	die( 'You are not allowed to call this page directly.' );
}

/**
 * @since 3.0
 */
class FrmProFieldHTML extends FrmFieldHTML {

	protected function field_settings_for_type() {
		$settings = parent::field_settings_for_type();

		FrmProFieldsHelper::fill_default_field_display( $settings );
		return $settings;
	}

	/**
	 * Do nothing when after_replace_html_shortcodes is called.
	 * We do not want any of the code in the FrmFieldHTML function to run.
	 * This is because the the shortcodes are processed instead in FrmProFieldsHelper::prepare_field_array.
	 *
	 * @since x.x
	 *
	 * @param array  $args
	 * @param string $html
	 *
	 * @return string
	 */
	protected function after_replace_html_shortcodes( $args, $html ) {
		return $html;
	}
}
